package cn.com.duiba.kjy.livecenter.api.enums.live;

import cn.com.duiba.kjy.livecenter.api.util.NumberUtil;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
public enum LiveInteractTypeEnum {

    MATERIAL(1,"资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveInteractTypeEnum(Integer type ,String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static List<Integer> welfareTypes;

    static {
        welfareTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType()));
    }

    public static boolean isWelfare(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTypes.contains(type);
    }
}
