package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播配置-红包相关配置
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveConfRedPacketSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15858153190848902L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包类型：1-开播，2-发红包
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketTypeEnum
     */
    private Integer redType;

    /**
     * true-只查询未领取完的
     * false-查询所有的
     */
    private boolean unfinished;
}