package cn.com.duiba.kjy.livecenter.api.remoteservice.resources;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveResource.ResourceDto;
import cn.com.duiba.kjy.livecenter.api.param.liveResource.ResourcePageQueryParam;

import java.util.List;

/**
 * 资源服务类
 * @author 吴文哲
 * @date 2020-04-01 13:57
 **/
@AdvancedFeignClient
public interface RemoteResourceService {

    /**
     * 新增/修改资源
     * @param dto
     * @return
     */
    Long saveResource(ResourceDto dto);


    /**
     * 根据主键逻辑删除
     * @param id
     * @return
     */
    Integer delById(Long id);


    /**
     * 根据主键查询
     * @param id
     * @return
     */
    ResourceDto findById(Long id);

    /**
     * 根据条件分页查询
     * @param pageQueryParam
     * @return
     */
    List<ResourceDto> findByCondition(ResourcePageQueryParam pageQueryParam);

    /**
     * 根据条件统计
     * @param pageQueryParam
     * @return
     */
    Integer countByCondition(ResourcePageQueryParam pageQueryParam);
}
