package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsTeamDto;
import cn.com.duiba.kjy.livecenter.api.param.statistics.LiveStatisticsTeamSearchParam;

import java.util.List;

/**
 * 团队纬度直播数据统计rpc服务
 * @author 吴文哲
 * @date 2020-03-30 15:52
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsTeamService {

    /**
     * 根据直播间id 团队id 获取统计数据
     * @param liveId
     * @param teamId
     * @return
     */
    LiveStatisticsTeamDto getByLiveIdAndTeamId(Long liveId,Long teamId);


    /**
     * 根据条件获取对应直播间 团队纬度统计数据
     * @param param
     * @return
     */
    List<LiveStatisticsTeamDto> getListByCondition(LiveStatisticsTeamSearchParam param);
}
