package cn.com.duiba.kjy.livecenter.api.enums.live;

/**
 * 领取失败错误码
 * @author lizhi
 * @date 2020/4/10 8:23 PM
 */
public enum LiveRedReceiveFailCodeEnum {

    /**
     * 10 业务端错误码
     */
    OPEN_ID_NOT_FIND(100001, "没找到openId"),
    OA_NOT_FIND(100002, "没找到oa"),
    IP_IS_EMPTY(100003, "ip为空"),
    AGENT_NUM_LIMIT(100004, "代理人名下领取人数超限"),
    QUEUE_LIMIT(100005, "队列已满"),
    DTO_IS_NULL(100006, "调用领取红包，返回结果为空"),
    RESULT_FAIL(100007, "调用领取红包，返回结果为失败"),
    NOT_FIND_AGENT(100008, "未找到绑定的代理人"),
    IP_NUM_LIMIT(100009, "ip下领取人数超限"),

    /**
     * 20 live center 错误码
     */
    CENTER_PARAM_ERROR(200001, "参数错误"),
    CENTER_LIVE_NOT_FIND(200002, "直播不存在"),
    CENTER_LIVE_IS_END(200003, "直播已结束"),
    CENTER_IP_LIMIT(200004, "ip领取超上限"),
    CENTER_AGENT_LIMIT(200005, "代理人名下领取人数超限"),
    CENTER_RED_NOT_FIND(200006, "红包不存在"),
    CENTER_RED_NOT_START(200007, "红包未开始"),
    CENTER_RED_END(200008, "红包已领完或已结束"),
    CENTER_HELP(200009, "助力人数不足"),
    CENTER_SAVE_RECEIVE_FAIL(200010, "保存领取记录失败"),
    CENTER_RANDOM_AMOUNT_IS_NULL(200011, "获取随机金额失败"),
    CENTER_SUB_AMOUNT_FAIL(200012, "扣库存失败"),
    CENTER_CALL_COMPANY_IS_NULL(200013, "调用企业付款失败"),
    CENTER_COMPANY_FAIL(200014, "企业付款到零钱结果失败"),
    CENTER_COMPANY_RECEIVING(200015, "企业付款到零钱结果领取中"),
    CENTER_IS_COMPANY_AGENT(200016, "是当前企业代理人"),
    ;

    private Integer code;
    private String desc;

    LiveRedReceiveFailCodeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
