package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveVisitorInvitationSearchParam;

/**
 * @author zhanghuifeng
 * date 2020/4/4-3:13 下午
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorInvitationService {

    /**
     * 查询数量
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(LiveVisitorInvitationSearchParam param);

    /**
     * 获取用户当前直播间邀请人数（纯缓存，不走DB）
     * @param liveUserId
     * @param liveId
     * @return
     */
    long findInviteCountCache(Long liveUserId, Long liveId);
}
