package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveUserAppointmentDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveUserAppointmentSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 用户预约服务
 * @author zhanghuifeng
 * date 2020/4/5-11:56 上午
 */
@AdvancedFeignClient
public interface RemoteLiveUserAppointmentService {

    /**
     * 保存
     * @param entity
     * @return
     */
    Boolean save(LiveUserAppointmentDto entity);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    int selectCount(LiveUserAppointmentSearchParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveUserAppointmentDto> findByCondition(LiveUserAppointmentSearchParam param);

    /**
     * 查询用户业务ID对应预约次数
     * @param liveUserId 用户ID
     * @param bizIdList 业务ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.UserAppointmentBizTypeEnum
     * @return key：业务ID，value：预约次数
     */
    Map<Long, Long> getUserBizAppointmentCount(Long liveUserId, List<Long> bizIdList, Integer bizType);
}
