package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueVisitDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueVisitSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveVisitEnterOutParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-03.
 */
@AdvancedFeignClient
public interface RemoteLiveClueVisitService {
    /**
     * 进入直播间，建立访问关系
     * @param param 用户信息
     * @return 增加条数
     */
    int enterLive(LiveVisitEnterOutParam param);

    /**
     * 退出直播间
     * @param param 用户信息
     * @return 修改条数
     */
    int outLive(LiveVisitEnterOutParam param);

    /**
     * 批量查询
     * @param param 查询条件
     * @return 符合条件的记录
     */
    List<LiveClueVisitDto> selectList(LiveClueVisitSearchParam param);

    /**
     * 批量查询
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(LiveClueVisitSearchParam param);

    /**
     * 根据直播ID和访客ID观看访问记录
     * @param liveId 直播ID
     * @param liveVisitorId 访客ID
     * @return
     */
    LiveClueVisitDto selectByLiveIdAndVisitId(Long liveId, Long liveVisitorId);

    /**
     * 原子性增加用户访问时长
     * @param liveId 直播ID
     * @param liveVisitorId 用户ID
     * @param addDuration 增加时长
     * @return
     */
    int addDuration(Long liveId, Long liveVisitorId, Long addDuration);

    /**
     * 根据访客ID和直播间ID查询观看时长
     * @param liveVisitorId
     * @param liveId
     * @return
     */
    Long findDurationWithCache(Long liveVisitorId, Long liveId);
}
