package cn.com.duiba.kjy.livecenter.api.remoteservice.welfare;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveWelfare.WelfareDto;
import cn.com.duiba.kjy.livecenter.api.param.welfare.WelfareQueryParam;

import java.util.List;

/**
 * 权益rpc接口
 * @author 吴文哲
 * @date 2020-04-01 10:45
 **/
@AdvancedFeignClient
public interface RemoteWelfareService {

    /**
     * 新增/修改 权益
     * @param dto
     * @return
     */
    Long saveWelfare(WelfareDto dto);

    /**
     * 根据主键删除  逻辑删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);


    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WelfareDto fingById(Long id);

    /**
     * 根据公司id查找 按照
     * @param queryParam
     * @return
     */
    List<WelfareDto> findByCondition(WelfareQueryParam queryParam);

    /**
     * 根据主键ID集合批量查询
     * @param ids
     * @return
     */
    List<WelfareDto> findByIds(List<Long> ids);

    /**
     * 领取权益
     * @param liveId
     * @param liveInteractConfId
     * @return 福利领取记录id
     */
    Long draw(Long liveId, Long liveInteractConfId, Long liveUserId);

}
