package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.CenterPageResult;
import cn.com.duiba.kjy.livecenter.api.dto.live.CompanyLivePlaybackDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.LivePlaybackDto;
import cn.com.duiba.kjy.livecenter.api.param.playback.PlaybackListParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-29.
 */
@AdvancedFeignClient
public interface RemoteLivePlaybackService {

    /**
     * 根据直播ID批量查询
     * @param liveId
     * @return
     */
    List<LivePlaybackDto> selectList(Long liveId);

    /**
     * 根据直播ID查询数量
     * @param liveId
     * @return
     */
    Long selectCount(Long liveId);

    /**
     * 查询回放列表
     * @param liveIds 直播主键集合
     * @return 上传的回放列表
     */
    List<LivePlaybackDto> selectListByLiveIds(List<Long> liveIds);

    /**
     * 新增记录
     * @param entity
     * @return
     */
    int insert(LivePlaybackDto entity);

    /**
     * 删除记录
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 根据直播ID物理删除
     * @param liveId 直播ID
     * @return 执行结果
     */
    int deleteByLiveId(Long liveId);

    /**
     *
     * @param param
     * @return
     */
    CenterPageResult<CompanyLivePlaybackDto> selectByCompanyId(PlaybackListParam param);

}
