package cn.com.duiba.kjy.livecenter.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播线索-观看记录
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
public class LiveClueVisitDto implements Serializable {
     
    private static final long serialVersionUID = 15853608937901526L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 第一次进入时间
     */
    private Date firstStartTime;

    /**
     * 最近一次进入时间
     */
    private Date lastStartTime;

    /**
     * 最近一次退出时间
     */
    private Date lastEndTime;

    /**
     * 最后一次访问时长，单位秒
     */
    private Integer lastDuration;

    /**
     * 总访问时长，单位秒
     */
    private Integer duration;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}