package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationBizDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationSimpleDto;
import cn.com.duiba.kjy.livecenter.api.param.invitation.BatchCreateNewAgentInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.BatchCreateNewVisitorInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewAgentInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewVisitorInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveAgentInvitationSearchParam;

import java.util.List;

/**
 * 邀请客户服务类
 * @author 吴文哲
 * @date 2020-03-30 19:52
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentInvitationService {

    /**
     * 获取被邀请人的列表
     * @param param
     * @return
     */
    List<LiveAgentInvitationDto> getInvitedUserList(LiveAgentInvitationSearchParam param);

    /**
     * 统计被邀请人数
     * @param param
     * @return
     */
    Integer countInvitedUser(LiveAgentInvitationSearchParam param);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param visitorId 被邀请人用户ID
     * @return 被邀请人代理人ID
     */
    Long findAgentByLiveAndVisitorId(Long liveId, Long visitorId);

    /**
     * 批量查询绑定代理人信息
     * @param liveId 直播ID
     * @param visitorIdList 被邀请人用户ID集合
     * @return 绑定代理人信息
     */
    List<LiveAgentInvitationSimpleDto> findAgentsByLiveAndVisitorIds(Long liveId, List<Long> visitorIdList);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param bizUserId 被邀请人业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return 邀请关系
     */
    LiveAgentInvitationBizDto findAgentByLiveAndBizUserIdAnType(Long liveId, String bizUserId, Integer bizType);

    /**
     * 新增绑定关系
     * @param param 参数
     * @return >0 绑定成功条数。正常 为1
     *
     */
    int insertAgentInvitation(CreateNewAgentInvitationParam param);

    /**
     * 新增访客邀请关系
     * @param param 访客信息
     * @return >0 绑定成功条数。正常 为1
     */
    int insertVisitorInvitation(CreateNewVisitorInvitationParam param);

    /**
     * 批量新增代理人邀请过绑定关系
     * @param params 搭理人列表
     * @param liveId 直播ID
     * @return 新增数量
     */
    int batchInsertAgentInvitation(List<BatchCreateNewAgentInvitationParam> params,Long liveId);

    /**
     * 批量新增访客邀请绑定关系
     * @param params 搭理人列表
     * @param liveId 直播ID
     * @return
     */
    int batchInsertVisitorInvitation(List<BatchCreateNewVisitorInvitationParam> params, Long liveId);

    /**
     * 跟新直播状态结束
     * @param liveId 直播ID
     * @return 跟新人数
     */
    Integer updateLiveStatusEnd(Long liveId);
}
