package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.user.BizUserIdDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveUserDto;
import cn.com.duiba.kjy.livecenter.api.param.user.LiveUserSearchParam;

import java.util.List;

/**
 * 直播用户服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveUserService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播用户集合
     */
    List<LiveUserDto> findList(LiveUserSearchParam queryParam);

    /**
     * 保存更新直播用户
     * @param dto 直播用户
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveUserDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播用户
     */
    LiveUserDto findById(Long id);

    /**
     * 根据第三方用户ID和类型查询用户ID
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return 主键id
     */
    Long findIdByBizUserIdAndType(String bizUserId, Integer bizType);

    /**
     * 查询授权电话
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return 授权电话
     */
    String findAuthPhoneByBizUserIdAndType(String bizUserId, Integer bizType);

    /**
     * 批量查询直播系统用户ID
     * @param bizUserIdList 业务方用户ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return 业务方ID和直播用户ID
     */
    List<BizUserIdDto> findIdsByBizUserIdsAndType(List<String> bizUserIdList, Integer bizType);


    /**
     * 根据id查询
     * @param ids 主键id列表
     * @return 直播用户
     */
    List<LiveUserDto> findByIds(List<Long> ids);

    /**
     * 更新授权手机号
     * @param id 主键
     * @param authPhone 授权手机号
     * @param authPhoneCountryCode 授权手机号的区号
     * @return 执行结果
     */
    int updateAuthPhone(Long id, String authPhone, String authPhoneCountryCode);

    /**
     * 更新授权手机号
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @param authPhone 授权手机号
     * @param authPhoneCountryCode 授权手机号的区号
     * @return 执行结果
     */
    int updateAuthPhoneByBiz(String bizUserId, Integer bizType, String authPhone, String authPhoneCountryCode);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Long deleteById(Long id);


    /**
     * 根据用户id 获取公司id
     * @param liveUserId
     * @return
     */
    Long findAdminCompanyIdByUserId(Long liveUserId);
    
}
