/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.enums.live;

import cn.com.duiba.kjy.livecenter.api.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.List;

public enum LiveInteractTypeEnum {
    MATERIAL(1, "\u56fe\u6587\u8d44\u6599"),
    QUESTION(2, "\u95ee\u9898"),
    SUBSCRIBE(3, "\u5173\u6ce8\u76f4\u64ad\u95f4"),
    ACCUMULATE_READ(4, "\u7d2f\u8ba1\u89c2\u770b"),
    FRIEND_INVITE(5, "\u9080\u8bf7\u597d\u53cb"),
    FREE_GET(6, "\u514d\u8d39\u9886"),
    GRAB_WELFARE(7, "\u62a2\u6743\u76ca"),
    CHOICE(8, "\u6d4b\u4e00\u6d4b"),
    LINK_RESOURCE(9, "\u94fe\u63a5\u8d44\u6599"),
    OA_RESOURCE(10, "\u516c\u4f17\u53f7\u8d44\u6599");

    private Integer type;
    private String desc;
    private static List<Integer> welfareTypes;
    public static List<Integer> resourceTypes;
    public static List<Integer> welfareTableTypes;

    private LiveInteractTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isWelfare(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return welfareTypes.contains(type);
    }

    public static boolean isResource(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return resourceTypes.contains(type);
    }

    public static boolean isWelfareTable(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return welfareTableTypes.contains(type);
    }

    public static void main(String[] args) {
        System.out.println(LiveInteractTypeEnum.isWelfare(2));
    }

    static {
        welfareTypes = Lists.newArrayList();
        welfareTypes.addAll(Lists.newArrayList((Object[])new Integer[]{MATERIAL.getType(), SUBSCRIBE.getType(), ACCUMULATE_READ.getType(), FRIEND_INVITE.getType(), FREE_GET.getType()}));
        resourceTypes = Lists.newArrayList();
        resourceTypes.addAll(Lists.newArrayList((Object[])new Integer[]{MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType()}));
        welfareTableTypes = Lists.newArrayList();
        welfareTableTypes.addAll(Lists.newArrayList((Object[])new Integer[]{SUBSCRIBE.getType(), ACCUMULATE_READ.getType(), FRIEND_INVITE.getType(), FREE_GET.getType(), GRAB_WELFARE.getType()}));
    }
}

