package cn.com.duiba.kjy.livecenter.api.param.clue;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 直播线索-奖励领取记录
 * @author kjj mybatis generator 
 * @date 2020-04-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveClueRewardSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15859185684608560L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 奖励ID
     */
    private Long rewardId;

    /**
     * 奖励类型：1-资料，2-关注直播间，3-累计观看，4-邀请好友，5-免费领，6-抢权益
     */
    private Integer rewardType;

    /**
     * 权益类型列表
     */
    private List<Integer> rewardTypes;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}