package cn.com.duiba.kjy.livecenter.api.param.statistics;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播统计-每场直播维度统计信息
 * @author kjj mybatis generator 
 * @date 2020-04-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveStatisticsSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15859053067461257L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 邀请人数
     */
    private Integer invitationNum;

    /**
     * 观看人数
     */
    private Integer visitorNum;

    /**
     * 裂变人数
     */
    private Integer fissionNum;

    /**
     * 线索数
     */
    private Integer clueNum;

    /**
     * 评论数
     */
    private Integer speakNum;

    /**
     * 新增关注人数
     */
    private Integer subscribeNum;

    /**
     * 访客平均观看时长
     */
    private Integer visitorAveDuration;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}