package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 直播
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15853608937806078L;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-直播结束
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveStatusEnum
     */
    private Integer liveStatus;

    /**
     * 直播状态集合
     */
    private List<Integer> liveStatusList;

    /**
     * 排序方式
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveSearchSortEnum
     */
    private int sort;
}