package cn.com.duiba.kjy.livecenter.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedDrawDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedDrawTicketDto;

import java.util.List;

/**
 * 红包抽奖服务
 * @author lizhi
 * @date 2020/6/19 11:40 AM
 */
@AdvancedFeignClient
public interface RemoteLiveRedDrawService {

    /**
     * 获取缓存中的手气王凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 手气王凭证，缓存中不存在则返回null
     */
    List<LiveRedDrawTicketDto> getLuckRedTicketList(Long liveId, Long confId);

    /**
     * 获取缓存中的普通红包凭证集合
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 普通红包凭证，缓存中不存在则返回null
     */
    List<LiveRedDrawTicketDto> getGeneralRedTicketList(Long liveId, Long confId);

    /**
     * 设置手气王红包凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param luckRedList 手气王凭证
     */
    void setLuckRedTicketList(Long liveId, Long confId, List<LiveRedDrawTicketDto> luckRedList);

    /**
     * 设置普通红包凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param generalRedList 普通红包凭证
     */
    void setGeneralRedTicketList(Long liveId, Long confId, List<LiveRedDrawTicketDto> generalRedList);

    /**
     * 清除所有的凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void clearRedTicketList(Long liveId, Long confId);


    /**
     * 获取缓存中的手气王中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 手气王中奖人集合
     */
    List<LiveRedDrawDto> getLuckRedList(Long liveId, Long confId);

    /**
     * 获取缓存中的普通红包中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 普通红包中奖人集合
     */
    List<LiveRedDrawDto> getGeneralRedList(Long liveId, Long confId);
}
