package cn.com.duiba.kjy.livecenter.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveRedPacketReceiveDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveRedPacketReceiveSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.red.LiveRedPacketDrawParam;

import java.util.List;
import java.util.Map;

/**
 * 领取记录
 * @author lizhi
 * @date 2020/6/19 1:59 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRedPacketReceiveService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播红包领取记录集合
     */
    List<LiveRedPacketReceiveDto> findPage(LiveRedPacketReceiveSearchParam param);

    /**
     * 根据领取记录ID，查询红包结果
     * @param id 领取记录ID
     * @return 领取结果
     */
    LiveRedPacketReceiveDto findById(Long id);

    /**
     * 批量新增
     * @param dtoList 领取记录集合
     * @return key：直播用户ID，value：主键
     */
    Map<Long, Long> batchInsert(List<LiveRedPacketReceiveDto> dtoList);

    /**
     * 批量更新
     * @param dtoList 领取记录集合
     * @return 更新结果
     */
    int batchUpdate(List<LiveRedPacketReceiveDto> dtoList);

    /**
     * 领取红包
     * @param param 领红包参数
     * @return 领红包记录
     */
    LiveRedPacketReceiveDto drawRedPacket(LiveRedPacketDrawParam param);
}
