package cn.com.duiba.kjy.livecenter.api.param.advice;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播咨询记录表
 * @author kjj mybatis generator
 * @date 2020-06-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveAdviceRecordSearchParam extends PageQuery {

    private static final long serialVersionUID = 15935024671273068L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播代理人id
     */
    private Long liveAgentId;

    /**
     * 聊天消息文本
     */
    private String msgText;

    /**
     * 已读标识 0：未读 1：已读
     */
    private Integer readFlag;

    /**
     * 回复类型 0：访客回复 1：代理人回复 2:代理人自动回复
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AdviceChatTypeEnum
     */
    private Integer chatType;

    /**
     * 起始创建时间 startGmtCreate <= gmtCreate
     */
    private Date startGmtCreate;

    /**
     * 结束创建时间 endGmtCreate > gmtCreate
     */
    private Date endGmtCreate;

    /**
     * 是否根据创建时间倒叙
     * true:倒叙
     * false：正序
     * null：不排序
     */
    private Boolean orderByGmtCreateDesc;
}
