package cn.com.duiba.kjy.livecenter.api.param.advice;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播代理人咨询记录表
 * @author kjj mybatis generator 
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveAgentAdviceStatisticsSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15935711159959095L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播代理人id
     */
    private Long liveAgentId;

    /**
     * 直播访客用户id集合
     */
    private List<Long> liveVisitorIds;

    /**
     * 是否根据最后聊天时间倒叙排列
     */
    private Boolean orderByLastChatTimeDesc;

    /**
     * 是否根据最早聊天时间正序排列
     */
    private Boolean orderByFirstChatTimeAsc;
}