package cn.com.duiba.kjy.livecenter.api.remoteservice.advice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.advice.LiveAdviceCountDto;
import cn.com.duiba.kjy.livecenter.api.dto.advice.LiveAdviceRecordDto;
import cn.com.duiba.kjy.livecenter.api.param.advice.LiveAdviceCountSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.advice.LiveAdvicePageParam;
import cn.com.duiba.kjy.livecenter.api.param.advice.LiveAdviceRecordSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/6/30 17:40
 */
@AdvancedFeignClient
public interface RemoteLiveAdviceRecordService {

    /**
     * 根据参数分页获取咨询记录
     * @param param 查询参数
     * @return 咨询记录集合
     */
    List<LiveAdviceRecordDto> findListByParam(LiveAdviceRecordSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播咨询记录集合
     */
    List<LiveAdviceRecordDto> selectAdviceList(LiveAdvicePageParam param);

    /**
     * 根据参数统计符合条件的总数
     * @param param 查询条件
     * @return 符合条件的总数
     */
    Integer countByParam(LiveAdviceRecordSearchParam param);

    /**
     * 批量查询聊天室记录数
     * @param param 查询参数
     * @return 记录数
     */
    List<LiveAdviceCountDto> batchSelectMsgCount(LiveAdviceCountSearchParam param);


    /**
     * 查询代理人未读消息数
     * @param liveId 直播id
     * @param agentId 代理人id
     * @param visitorIds 访客用户id集合
     * @return key：访客用户id value：未读消息数
     */
    Map<Long, Integer> getVisitorNotReadNumMap(Long liveId, Long agentId, List<Long> visitorIds);
}
