package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueRewardDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueRewardVisitorIdDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveUserRewardCountDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveCLueRewardFindParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardPageParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 直播线索-奖励领取记录remote
 * @author zhanghuifeng
 * date 2020/4/3-9:17 下午
 */
@AdvancedFeignClient
public interface RemoteLiveClueRewardService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播线索-奖励领取记录
     */
    LiveClueRewardDto findById(Long id);

    /**
     * 新增
     * @param dto 直播线索-奖励领取记录
     * @return 执行结果
     */
    Boolean add(LiveClueRewardDto dto);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveClueRewardSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播线索-奖励领取记录集合
     */
    List<LiveClueRewardDto> selectPage(LiveClueRewardSearchParam param);

    /**
     * 分页查询
     * @param pageParam
     * @return
     */
    @Deprecated
    Page<LiveClueRewardDto> page(LiveClueRewardPageParam pageParam);

    /**
     * 根据直播间ID、用户ID、权益ID集合查询每个权益领取数量
     * @param liveId
     * @param liveVisitorId
     * @param rewardIds
     * @return
     */
    List<LiveUserRewardCountDto> findCountByLiveAndUserAndRewardIds(Long liveId, Long liveVisitorId, List<Long> rewardIds,
                                                                    List<Integer> rewardTypes);

    /**
     * 查询一个用户的领取记录
     * @param param 直播+福利ID+福利类型+用户ID 组成的唯一索引
     * @return
     */
    LiveClueRewardDto findUserReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 查询一个用户的爆款领取记录
     * @param param 直播+用户ID （爆款福利一场直播只能领取一次）
     * @return 爆款福利
     */
    LiveClueRewardDto findUserBoomReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 批量查询用户领取数量
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @param rewardType 福利类型，可为空
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     * @param rewardId 福利ID，可为空
     * @return key：用户ID，value：领取数量
     */
    Map<Long, Long> findUserReceiveCount(Long liveId, List<Long> liveVisitorIdList, Integer rewardType, Long rewardId);

    /**
     * 查询福利领取数量
     * @param rewardIdList 福利ID集合
     * @return 福利领取数量
     */
    Map<Long, Long> findRewardCount(List<Long> rewardIdList);

    /**
     * 批量插入，并将抽奖码变为已使用，并扣减爆款福利库存
     * @param confId 配置ID，用于爆款福利扣减库存
     * @param list 直播线索-奖励领取记录集合
     * @return 主键及用户ID
     */
    List<LiveClueRewardVisitorIdDto> batchInsertAndUseCode(Long confId, List<LiveClueRewardDto> list);
}
