package cn.com.duiba.kjy.livecenter.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播红包领取记录
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
public class LiveRedPacketReceiveDto implements Serializable {
     
    private static final long serialVersionUID = 15858340744369906L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包配置ID
     */
    private Long confRedPacketId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 红包金额
     */
    private Integer amount;

    /**
     * 领取状态：1-未领取，2-领取中，3-领取成功，4-领取失败
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketReceiveStatusEnum
     */
    private Integer receiveStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 用户真实ip
     */
    private String clientIp;

    /**
     * 错误码信息
     */
    private String errCode;

    /**
     * 失败原因
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedReceiveFailCodeEnum
     */
    private Integer failCode;

    /**
     * 红包类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.red.LiveRedReceiveTypeEnum
     */
    private Integer receiveType;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}