package cn.com.duiba.kjy.livecenter.api.dto.red;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播配置-红包相关配置
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
public class LiveConfRedPacketDto implements Serializable {
     
    private static final long serialVersionUID = 158581531908280L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 普通红包金额
     */
    private Integer amount;

    /**
     * 普通红包数量
     */
    private Integer num;

    /**
     * 普通红包剩余金额
     */
    private Integer surplusAmount;

    /**
     * 普通红包剩余数量
     */
    private Integer surplusNum;

    /**
     * 普通红包需要助力人数
     */
    private Integer helpNum;

    /**
     * 多少分钟之后开抢
     */
    private Integer afterMin;

    /**
     * 开抢时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 红包类型：1-开播，2-发红包
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketTypeEnum
     */
    private Integer redType;

    /**
     * 红包状态：1-未发布，2-已发布，3-已结束
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketStatusEnum
     */
    private Integer redStatus;

    /**
     * 手气王红包金额
     */
    private Integer luckAmount;

    /**
     * 手气王红包数量
     */
    private Integer luckNum;

    /**
     * 手气王红包剩余金额
     */
    private Integer luckSurplusAmount;

    /**
     * 手气王红包剩余数量
     */
    private Integer luckSurplusNum;

    /**
     * 手气王需要助力人数
     */
    private Integer luckHelpNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 总红包金额
     */
    public Integer getTotalAmount() {
        return amount + (luckAmount * luckNum);
    }

    /**
     * 总红包数量
     */
    public Integer getTotalNum() {
        return num + luckNum;
    }

    public Integer getTotalSurplusNum() {
        return surplusNum + luckSurplusNum;
    }
}