package cn.com.duiba.kjy.livecenter.api.enums.live;

/**
 * web socket 消息类型
 * @author lizhi
 * @date 2020/3/24 7:17 PM
 */
public enum WsMsgTypeEnum {

    //web socket 返回的对象，如果需要加密ID，请使用@JSONField，
    //参照cn.com.duiba.kjy.liveweb.vo.websocket.WsLiveRedHelpVo

    //10代表客集集，01代表红包业务，01-是具体的推送
    KJY_RED_REAL(100101, "推送实时红包"),
    KJY_RED_FINISHED(100102, "推送红包被领取完了"),
    KJY_RED_HELP(100103, "推送红包助力"),
    KJY_RED_START_AFTER_USER_SUBSCRIBE(100104, "用户订阅成功时推送开播红包"),
    KJY_RED_REAL_AFTER_USER_SUBSCRIBE(100105, "用户订阅成功时推送实时红包"),
    KJY_RED_AFTER_USER_SUBSCRIBE(100106, "用户订阅成功时推送是否有红包"),
    KJY_RED_REFRESH(100107, "助播新增或发布了红包"),
    KJY_RED_LIST_AFTER_USER_SUBSCRIBE(100108, "用户订阅成功时推送红包数组"),

    //02 互动相关
	KJY_SPOKE(100201,"弹幕"),
    KJY_NEW_VISITOR(100202,"有人来了"),
    KJY_INTIME_DATA(100203,"直播间实时数据"),
    KJY_BANNED(100204,"禁言标志"),
    KJY_SHARE(100205,"分享直播间"),
    KJY_START(100206,"直播开始"),
    KJY_NOTICE(100207,"管理员公告"),

    KJY_END(100209,"直播结束"),
    KJY_BREAK(100210,"直播断开"),
    KJY_CONTINUE(100211,"直播继续"),
    KJY_SPOKE_LIST(100212,"最近30条弹幕列表"),
    KJY_QUESTION_NEW(100213,"管理员提问列表"),
    KJY_EXPLAIN(100214,"发布直播讲解介绍配置推送"),
    KJY_EXPLAIN_CLOSE(100215,"关闭直播讲解介绍配置推送"),

    // 03代表权益业务
    KJY_LIVE_REWARD_PRODUCT(100301, "推送权益"),
    KJY_LIVE_WELFARE_DRAW(100302, "推送已领取权益"),
    KJY_LIVE_REWARD_LOTTERY_START(100303, "福利抽奖开始"),
    KJY_LIVE_REWARD_LOTTERY_END(100304, "福利抽奖结束"),
    KJY_LIVE_WATCH_TIME_LOTTERY_CODE(100305, "观看时长满20分钟获得抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_AFTER_USER_SUBSCRIBE(100306, "用户订阅成功时推送正在抽奖的福利"),
    KJY_LIVE_REWARD_LOTTERY_APPOINTMENT(100307,"获得预约直播间的抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_SIGN(100308,"获得签到抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_SUBSCRIBE(100309,"获得订阅抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_INVITATION(100310,"获得邀请抽奖码"),

    /**
     * 测一测
     * 04
     */
    KJY_LIVE_CHOICE_QUESTION_PUSH(100401,"测一测推送"),
    KJY_LIVE_CHOICE_CLOSE(100402,"测一测关闭"),

    /**
     * 咨询
     * 05
     */
    KJJ_LIVE_ADVICE_NEW_MSG(100501, "有新消息到达"),
    KJJ_LIVE_ADVICE_READ(100502, "消息已读"),
    KJJ_LIVE_ADVICE_SEND_RESULT(100503, "消息发送结果"),
    ;
    private int type;
    private String desc;

    WsMsgTypeEnum(int type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
