package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsResult4PersonalDto;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsResultDto;

import java.io.Serializable;
import java.util.List;

/**
 * websocket定时推送 【通用队列】操作。 包含用户类型【所有用户】【指定用户】 包含类型【插入】【查询】
 * !important 当通用队列达到限流瓶颈时，限流策略（动态可配置,默认不丢弃）可能选择丢弃。所以【重要推送（不可丢弃）】请选择其他方法。
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteCommonPushService {

    /**
     * 往队列中添加需要推送给全部用户的推送
     * @param liveId 直播ID
     * @param wsResultDto 推送内容 请确保 范型《T》是center的dto。否则反序列化告警。降级为hashMap
     */
    <T extends Serializable> void addPushAll(Long liveId, WsResultDto<T> wsResultDto);

    /**
     * 获取最近1s内需要给全部用户推送的消息
     * @param liveId 直播ID
     * @return 由于redis【通用队列】中的数据类型不一致，为解决反序列话的问题，统一用String
     */
    List<WsResultDto<String>> getRecentlyPushAll(Long liveId);

    /**
     * 往队列中添加需要推送给指定用户的推送
     * @param liveId 直播ID
     * @param wsResult4Personal 推送内容  请确保 范型《T》是center的dto。否则反序列化告警。降级为hashMap
     */
    <T extends Serializable> void addPushOnePerson(Long liveId, WsResult4PersonalDto<T> wsResult4Personal);

    /**
     * 获取最近1s内需要推送给指定用户的消息
     * @param liveId 直播ID
     * @return 由于redis【通用队列】中的数据类型不一致，为解决反序列话的问题，统一用String
     */
    List<WsResult4PersonalDto<String>> getRecentlyPushOnePerson(Long liveId);
}
