package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by dugq on 2020-06-28.
 */
@AdvancedFeignClient
public interface RemoteLiveBannedSpokeService {
    /**
     * 禁言
     * @param liveId
     * @param liveUserId
     */
    void bannedSpoke(Long liveId, Long liveUserId);

    /**
     * 放开禁言
     * @param liveId
     * @param liveUserId
     */
    void releaseBannedSpoke(Long liveId, Long liveUserId);

    /**
     * 判断用户是否被禁言
     * @param liveId
     * @param liveUserId
     * @return
     */
    boolean isBannedSpoke(Long liveId, Long liveUserId);
}
