package cn.com.duiba.kjy.livecenter.api.remoteservice.liveconf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveInteract.LiveInteractConfDto;
import cn.com.duiba.kjy.livecenter.api.param.liveInteract.LiveInteractConfQueryParam;

import java.util.List;

/**
 * 直播互动配置服务rpc类
 * @author 吴文哲
 * @date 2020-04-02 15:27
 **/
@AdvancedFeignClient
public interface RemoteLiveInteractConfService {

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveInteractConfDto> findByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据条件查询总数
     * @param param
     * @return
     */
    int countByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    LiveInteractConfDto selectById(Long id);

    /**
     * 单条插入 返回主键
     * @param dto
     * @return
     */
    Long insert(LiveInteractConfDto dto);

    /**
     * 保存资料配置
     * @param liveId 直播ID
     * @param intreactIdList 互动ID集合
     * @return 执行结果
     */
    int saveResourceConf(Long liveId, List<Long> intreactIdList);

    /**
     * 批量插入
     * @param dtoList 需要修改的列表
     * @param liveId 直播间id
     * @param interactType 互动类型
     * @return
     */
    Integer batchUpdate(List<LiveInteractConfDto> dtoList,Long liveId,Integer interactType);

    /**
     * 更新
     * @param dto 福利配置信息
     * @return 执行结果
     */
    int update(LiveInteractConfDto dto);
}
