package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsWelfareDto;

import java.util.List;

/**
 * 领取福利推送
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteUserDrawWelfareService {

    /**
     * 追加新用户
     * 每秒一个队列。每个队列有效期3s
     * @param liveId 直播ID
     * @param dto 需要推送的消息
     */
    void addUser(Long liveId, WsWelfareDto dto);

    /**
     * 获取最近1s的用户
     * 取最近1秒队列中的所有数据
     * @param liveId 直播ID
     * @return 领取福利推送
     */
    List<WsWelfareDto> getRecentlyUser(Long liveId);
}
