package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyTeamCountDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyTeamDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Created with duiba.
 * User: zhouzhou
 * Date: 2020/3/31 0031 Time: 10:44
 * <p>
 * Description: 兑吧专属的分页转换小工具
 */
public class PageUtils {

    /**
     * 把一个Page转换成另一page
     * @param sourcePage
     * @param clazz
     * @param <T>
     * @return
     */
    public static  <T extends Serializable> Page<T> convertPage(Page<?> sourcePage, Class<T> clazz) {
        Page<T> page = new Page<>();
        BeanUtils.copy(sourcePage, page);
        List<?> list = sourcePage.getList();
        if (CollectionUtils.isEmpty(list)) {
            page.setList(Lists.newArrayList());
        }else{
            List<T> targetList = BeanUtils.copyList(list, clazz);
            page.setList(targetList);
        }
        return page;

    }

    public static void main(String[] args) {
        Page<LiveCompanyTeamDto> pageList = new Page<>();
        List<LiveCompanyTeamDto> teamDtos = Lists.newArrayList();
        LiveCompanyTeamDto companyTeamDto = new LiveCompanyTeamDto();
        companyTeamDto.setId(1L);
        companyTeamDto.setTeamName("1号");
        companyTeamDto.setCompanyId(2L);
        LiveCompanyTeamDto companyTeamDto2 = new LiveCompanyTeamDto();
        companyTeamDto2.setId(2L);
        companyTeamDto2.setTeamName("2号");
        companyTeamDto2.setCompanyId(3L);
        teamDtos.add(companyTeamDto);
        teamDtos.add(companyTeamDto2);
        pageList.setList(teamDtos);
        pageList.setTotalCount(2);
        pageList.setPageSize(3);
        pageList.setPageIndex(1);
        pageList.setHasNext(false);

        Page<LiveCompanyTeamCountDto> liveCompanyTeamCountDtoPage = convertPage(pageList, LiveCompanyTeamCountDto.class);
        System.out.println(liveCompanyTeamCountDtoPage);

    }

}