package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by dugq on 2020-06-28.
 */
@AdvancedFeignClient
public interface  RemoteLiveDataInTimeService {
    /**
     * 批量增加直播间在线人数
     * @param liveId 直播ID
     * @param count 增加人数
     */
    void atomicBatchIncreaseOnlineNum(Long liveId, Long count);

    /**
     * 批量减去直播间在线人数
     * @param liveId 直播ID
     * @param count 减去人数
     */
    void atomicBatchMinusOnlineNum(Long liveId, Long count);

    /**
     * 获取直播间的在线人数
     * @param liveId 直播ID
     * @return 在线人数
     */
    Long getOnlineNum(Long liveId);

    /**
     * 批量增加直播间观看人数
     * @param liveId 直播ID
     * @param count 增加人数
     */
    void atomicBatchIncreaseWitchNum(Long liveId, Long count);


    /**
     * 把直播间的在评论数自增 num
     * @param liveId 直播ID
     */
    void atomicIncreaseCommentNum(Long liveId, Long num);

    /**
     * 获取直播间的评论数
     * @param liveId 直播ID
     * @return 评论数
     */
    Long getCommentNum(Long liveId);

    /**
     * 获取直播间观看数
     * @param liveId
     * @return
     */
    Long getWitchNum(Long liveId);

    /**
     * 把直播间的分享人数自增1
     * @param liveId 直播ID
     */
    void atomicIncreaseShareNum(Long liveId);


    /**
     * 获取直播间的分享数
     * @param liveId 直播ID
     * @return 分享数
     */
    Long getShareNum(Long liveId);
}
