package cn.com.duiba.kjy.livecenter.api.dto.advice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播代理人咨询记录表
 * @author kjj mybatis generator 
 * @date 2020-07-01
 */
@Data
public class LiveAgentAdviceStatisticsDto implements Serializable {
     
    private static final long serialVersionUID = 15935711159928788L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播代理人id
     */
    private Long liveAgentId;

    /**
     * 聊天消息文本
     */
    private String msgText;

    /**
     * 唯一标识，由live_id-live_agent_id-live_visitor_id组成
     */
    private String sessionKey;

    /**
     * 推送标识
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer pushFlag;

    /**
     * 最早聊天时间
     */
    private Date firstChatTime;

    /**
     * 最晚聊天时间
     */
    private Date lastChatTime;

}