package cn.com.duiba.kjy.livecenter.api.dto.aliyunlive;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 阿里云app直播违规记录
 * @author kjj mybatis generator 
 * 2020-03-27
 */
@Data
public class DetectionRecordDto implements Serializable {
    private static final long serialVersionUID = 15852889338266578L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *直播app的ID
     * not null default = null
     */
    private Long appId;

    /**
     *
     *直播记录
     * not null default = null
     */
    private Long streamId;

    /**
     *
     *ossObjectName
     * max length = 255
     * not null default = null
     */
    private String objectName;

    /**
     *
     *违规类型
     * max length = 50
     * not null default = null
     */
    private String label;

    /**
     *
     *处理建议：pass，review，block
     * max length = 10
     * not null default = null
     */
    private String suggestion;

    /**
     *
     *检测场景
     * max length = 25
     * not null default = null
     */
    private String scene;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}