package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueQuestionDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueQuestionSearchParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-03.
 */
@AdvancedFeignClient
public interface RemoteLiveClueQuestionService {


    /**
     * 批量查询
     * @param param 查询条件
     * @return 用户提问记录
     */
    List<LiveClueQuestionDto> selectList(LiveClueQuestionSearchParam param);

    /**
     * 查询数量
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(LiveClueQuestionSearchParam param);

    /**
     * 新增线索记录
     * @param dto 问题线索
     * @return 新增数量
     */
    int insert(LiveClueQuestionDto dto);

    /**
     * 批量插入
     * @param entity
     * @return
     */
    int batchInsert(List<LiveClueQuestionDto> entity);
}
