package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.admin.LiveAdminCompanyRelatedDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAdminDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAdminInsertDto;
import cn.com.duiba.kjy.livecenter.api.param.admin.LiveAdminAuthCompanyQueryParam;
import cn.com.duiba.kjy.livecenter.api.param.admin.LiveAdminChangeCompanyParam;
import cn.com.duiba.kjy.livecenter.api.param.admin.LiveAdminCompanyAuthParam;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveAdminSearchParam;

import java.util.List;

/**
 * 直播公司管理员服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveAdminService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播公司管理员集合
     */
    List<LiveAdminDto> findList(LiveAdminSearchParam queryParam);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(LiveAdminSearchParam param);

    /**
     * 保存直播公司管理员
     * @param dto 直播公司管理员
     * @return 主键，为0，说明新增失败
     */
    Long save(LiveAdminInsertDto dto);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer deleteById(Long id);

    /**
     * 根据主键id查找
     * @param adminId
     * @return
     */
    LiveAdminDto findById(Long adminId);

    /**
     * 根据userID查询管理员
     * @param userId
     * @return
     */
    LiveAdminDto findByUserId(Long userId);

    /**
     * 根据管理员id 公司列表查询管理员对应的公司权限
     * @param adminId
     * @param companyIds
     * @return
     */
    List<LiveAdminCompanyRelatedDto> findAuthCompanyListByAdminId(Long adminId, List<Long> companyIds);

    /**
     * 保存直播管理员公司授权信息
     * @param adminId 管理员id
     * @param authParams 授权信息参数
     * @return
     */
    Boolean saveAdminAuth(Long adminId, List<LiveAdminCompanyAuthParam> authParams);

    /**
     * 根据条件统计公司/管理员关系列表数
     * @param param
     * @return
     */
    Integer countAdminCompanyRelatedByCondition(LiveAdminAuthCompanyQueryParam param);

    /**
     * 根据条件查询公司/管理员绑定关系列表
     * @param param
     * @return
     */
    List<LiveAdminCompanyRelatedDto> findAdminCompanyRelatedListByCondition(LiveAdminAuthCompanyQueryParam param);

    /**
     * 直播代理人切换公司
     * @param changeParam
     * @return
     */
    Boolean changeCompany(LiveAdminChangeCompanyParam changeParam);


}
