package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAgentDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveAgentCompanyDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveAgentSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.liveagent.LiveAgentPageQueryParam;
import cn.com.duiba.kjy.livecenter.api.param.user.AgentUpdate4KjjParam;

import java.util.List;
import java.util.Map;

/**
 * 直播代理人rpc服务类
 * @author 吴文哲
 * @date 2020-03-30 21:00
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentService {


    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司团队
     */
    LiveAgentDto findById(Long id);

    /**
     * 根据主键id查找列表
     * @param ids
     * @return
     */
    List<LiveAgentDto> findByIds(List<Long> ids);

    /**
     * 根据团队id 统计
     * @param teamId
     * @return
     */
    Integer countByTeamId(Long teamId);

    /**
     * 将代理人从团队中移除
     * @return
     */
    Integer removeAgentFromTeam(Long agentId,Long teamId);

    /**
     * 根据团队id 查找直播代理人列表
     * @param teamId
     * @return
     */
    List<LiveAgentDto> findByTeamId(Long teamId);

    /**
     * 从缓存中获取代理人的公司id
     * @param agentId
     * @return
     */
    Long getCompanyIdByAgentIdFromCache(Long agentId);

    /**
     * 根据直播用户id 查找代理人信息
     * @param liveUserId
     * @return
     */
    LiveAgentDto findByLiveUserId(Long liveUserId);

    /**
     * 批量查询公司ID
     * @param liveUserIdList 直播用户ID
     * @return 代理人公司ID集合
     */
    List<LiveAgentCompanyDto> findCompanyByLiveUserIds(List<Long> liveUserIdList);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<LiveAgentDto> findListByCondition(LiveAgentPageQueryParam param);

    /**
     * 判断是否是当前公司代理人
     * @param liveUserId
     * @param companyId
     * @return true是 false否
     */
    boolean isCurrentCompanyAgent(long liveUserId, long companyId);

    /**
     * 更新代理人客集集系统参数
     * @param param
     * @return
     */
    Integer updateAgent4Kjj(AgentUpdate4KjjParam param);

    /**
     * 查询公司所有代理人
     * @param companyId 公司ID
     * @return key：代理人用户ID，value：代理人ID
     */
    Map<Long, Long> findByCompanyIdCache(Long companyId);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveAgentSearchParam param);

    /**
     * 根据条件查询，分页
     * @param queryParam 查询条件
     * @return 直播公司代理人集合
     */
    List<LiveAgentDto> selectPage(LiveAgentSearchParam queryParam);

    /**
     * 根据公司id统计公司下团队人数
     * @return
     */
    Map<Long,Integer> countByCompanyIdList();

    /**
     * 根据公司id统计代理人人数
     * @param companyId
     * @return
     */
    Integer countByCompanyId(Long companyId);

}
