package cn.com.duiba.kjy.livecenter.api.remoteservice.resources;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveResource.AssistPushDto;

/**
 * 主播端，推送相关（资料、业务员名片）
 * @author lizhi
 * @date 2020/8/4 3:05 PM
 */
@AdvancedFeignClient
public interface RemoteAssistPushService {

    /**
     * 获取上架中的推送
     * @param liveId 直播ID
     * @return 上架中的推送
     */
    AssistPushDto findOnAssistPushDto(Long liveId);

    /**
     * 上架推送
     * @param liveId 直播ID
     * @param dto 要上架的推送
     * @return 是否成功
     */
    boolean on(Long liveId, AssistPushDto dto);

    /**
     * 下架推送
     * @param liveId 直播ID
     * @return 是否成功
     */
    boolean off(Long liveId);

}
