package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播配置-代理人奖励
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveConfRewardAgentSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15853608937933995L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 奖品名称
     */
    private Long prizeName;

    /**
     * 排名
     */
    private Integer ranking;

    /**
     * 奖励类型，1-个人，2-团队
     */
    private Byte rewardType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}