package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15853608937806078L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 宣传海报
     */
    private String posterUrl;

    /**
     * 宣传视频
     */
    private String videoUrl;

    /**
     * 直播标题
     */
    private String title;

    /**
     * 当前主播用户ID
     */
    private Long announcerUserId;

    /**
     * 预告时间
     */
    private Date noticeTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-直播结束
     */
    private Byte liveStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}