/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import java.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdMakeUtil {
    private static final Logger log = LoggerFactory.getLogger(IdMakeUtil.class);
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final String PREFIX = "Kj2";

    protected IdMakeUtil() {
    }

    protected static String encodingId(Long id) {
        id = id << 3 ^ 7L;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return PREFIX + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank((String)encode)) {
            return null;
        }
        try {
            StringBuilder substring = new StringBuilder(encode.substring(4));
            if (encode.startsWith(PREFIX)) {
                int equalNum = encode.charAt(3);
                for (int i = 0; i < equalNum; ++i) {
                    substring.append("=");
                }
            }
            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        }
        catch (Exception e) {
            log.info("decode ID error; id = {}", (Object)encode, (Object)e);
            return null;
        }
    }
}

