package cn.com.duiba.kjy.livecenter.api.dto.wspush.advice;

import cn.com.duiba.kjy.livecenter.api.util.IdFastJsonSerializable;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 消息发送结果
 * @author lizhi
 * @date 2020/7/2 5:27 PM
 */
@Data
public class WsAdviceSendResultDto implements Serializable {

    private static final long serialVersionUID = -623492819114732762L;

    /**
     * 消息主键
     */
    @JSONField(serializeUsing = IdFastJsonSerializable.class)
    private Long id;

    /**
     * 会话ID
     */
    private String sessionId;

    /**
     * 前端消息唯一标识
     */
    private String uuid;

    /**
     * 发送结果
     */
    private boolean sendResult;

    /**
     * 失败描述
     */
    private String errMsg;

    /**
     * 失败错误码
     */
    private String errCode;
}
