package cn.com.duiba.kjy.livecenter.api.remoteservice.activate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.activate.ActivateImportDataDto;
import cn.com.duiba.kjy.livecenter.api.dto.activate.ActivateImportFailureDataDto;
import cn.com.duiba.kjy.livecenter.api.param.activate.ActivateImportDataSearchParam;

import java.util.List;

/**
 * 直播账号激活，导入数据
 * @author lizhi
 * @date 2020/7/20 10:29 AM
 */
@AdvancedFeignClient
public interface RemoteActivateImportDataService {

    /**
     * 根据手机号查询导入数据
     * @param phoneNumber 手机号
     * @return 导入数据
     */
    ActivateImportDataDto findByPhoneNumber(String phoneNumber);

    /**
     * 根据条件查询主键，分页
     * @param param 分页查询条件
     * @return 主键集合
     */
    List<Long> findIdPage(ActivateImportDataSearchParam param);

    /**
     * 批量新增
     * @param list 直播账号激活导入数据
     * @return 执行结果
     */
    int batchInsert(List<ActivateImportDataDto> list);

    /**
     * 批量物理删除
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 批量插入失败数据
     * @param failureList
     * @return
     */
    Integer batchInsertFailureData(List<ActivateImportFailureDataDto> failureList);

    /**
     * 根据导入任务id 获取失败列表
     * 瀑布流查询
     * @return
     */
    List<ActivateImportFailureDataDto> getFailureListByTaskId(Long taskId ,Long lastMaxId,Integer pageSize);

    /**
     * 根据taskId 统计总数
     * @param taskId
     * @return
     */
    Long countFailureByTaskId(Long taskId);

    /**
     * 根据手机号查询详情
     * @param phoneList
     * @return
     */
    List<ActivateImportDataDto> findByPhoneList(List<String> phoneList);
}
