package cn.com.duiba.kjy.livecenter.api.remoteservice.activate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.activate.LiveAgentImportTaskDto;
import cn.com.duiba.kjy.livecenter.api.param.activate.LiveAgentImportTaskSearchParam;

import java.util.List;

/**
 * 直播代理人导入任务服务rpc接口
 * @author 吴文哲
 * @date 2020-08-28 16:01
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentImportTaskService {

    /**
     * 根据条件查询任务列表
     * @return
     */
    List<LiveAgentImportTaskDto> getImportTaskByCondition(LiveAgentImportTaskSearchParam searchParam);

    /**
     * 根据条件统计
     * @param searchParam
     * @return
     */
    Long countImportByCondition(LiveAgentImportTaskSearchParam searchParam);

    /**
     * 新增任务记录
     * @param taskEntity
     * @return
     */
    Long addImportTask(LiveAgentImportTaskDto taskEntity);

    /**
     * 叠加总数
     * @param id
     * @param totalCount
     * @return
     */
    Integer increaseTotalCount(Long id,Integer totalCount);

    /**
     * 叠加成功总数
     * @param id
     * @param successCount
     * @return
     */
    Integer increaseSuccessCount(Long id,Integer successCount);

    /**
     * 叠加失败总数
     * @param id
     * @param failureCount
     * @return
     */
    Integer increaseFailureCount(Long id,Integer failureCount);

    /**
     * 根据之间查找
     * @param id
     * @return
     */
    LiveAgentImportTaskDto findById(Long id);

    /**
     * 任务状态
     * @param taskStatus
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AgentImportTaskEnum
     * @return
     */
    Boolean updateStatus(Long id,Integer taskStatus);
}
