package cn.com.duiba.kjy.livecenter.api.dto.live;

import lombok.Data;

import java.io.Serializable;

/**
 * 用户预约推送表
 * @author kjj mybatis generator 
 * @date 2020-08-03
 */
@Data
public class LiveUserAppointmentPushDto implements Serializable {
     
    private static final long serialVersionUID = 15964443497056658L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 预约ID（tb_live_user_appointment.id）
     */
    private Long appointmentId;

    /**
     * 预约业务ID（tb_live_user_appointment.biz_id）
     */
    private Long appointmentBizId;

    /**
     * 推送类型 1-开播提醒、2-活动开奖通知、3-活动领取通知
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.push.PushTypeEnum
     */
    private Integer pushType;

    /**
     * 推送业务ID
     */
    private Long pushBizId;

    /**
     * 直播用户ID
     */
    private Long liveUserId;
}