package cn.com.duiba.kjy.livecenter.api.dto.push;

import cn.com.duiba.kjy.livecenter.api.enums.push.LivePushTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播推送管理表
 * @author kjj mybatis generator 
 * @date 2020-07-11
 */
@Data
public class LivePushManagerDto implements Serializable {
     
    private static final long serialVersionUID = 15944381116805497L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 推送时间
     */
    private Date pushReleaseTime;

    /**
     * 推送类型 1：按类型推送 2：按销售id推送
     * @see LivePushTypeEnum
     */
    private Integer pushType;

    /**
     * 是否启用推送，0=未启用 1=启用
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer enableState;

    /**
     * 状态，1=未开始、2=成功、3=失败 4=执行中 5=推送过期
     * @see cn.com.duiba.kjy.livecenter.api.enums.push.LivePushStateEnum
     */
    private Integer pushState;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer deleted;

    /**
     * 直播公司id
     */
    private Long companyId;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 1:客服文字消息 2:客服图片消息
     * @see cn.com.duiba.kjy.livecenter.api.enums.push.LivePushMessageTypeEnum
     */
    private Integer messageType;

    /**
     * 客服文字消息的内容
     */
    private String customWords;

    /**
     * 代理人id集合
     */
    private String sellerIds;

    /**
     * 模版消息跳转URL
     */
    private String templateId;

    /**
     * 模版消息跳转URL
     */
    private String templateUrl;

    /**
     * 模版消息内容的json
     */
    private String templateJson;

    /**
     * 图片消息的微信返回的ID
     */
    private String picMediaId;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 标题
     */
    private String title;

    /**
     * 图片链接
     */
    private String picUrl;

    /**
     * 跳转链接
     */
    private String url;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}