package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveConfRewardPkDto;

import java.util.List;

/**
 * 直播配置奖励rpc服务
 *
 * @author 吴文哲
 * @date 2020-03-30 20:18
 **/
@AdvancedFeignClient
public interface RemoteLiveConfRewardPkService {


    /**
     * 根据直播ID和类型查询
     *
     * @param liveId     直播ID，不可为空
     * @param rewardType 奖励类型，1-个人，2-团队，可为空
     * @return 直播配置-pk奖励集合
     */
    List<LiveConfRewardPkDto> selectByLiveIdAndType(Long liveId, Integer rewardType);

    /**
     * 批量更新
     *
     * @param dtoList dto列表
     * @param liveId 直播间id
     * @param rewardType 奖励类型
     * @return
     */
    Integer batchUpdateReward(List<LiveConfRewardPkDto> dtoList, Long liveId, Integer rewardType);

}
