package cn.com.duiba.kjy.livecenter.api.util;

import org.apache.commons.collections.CollectionUtils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

/**
 * Created by dugq on 2020-05-05.
 */
public class KjyUtils {
    private KjyUtils(){}

    /**
     * 根据condition的值作为唯一条件，去除list中重复value
     * @param list 原list
     * @param condition 生成唯一key的函数表达式
     * @param <T> list中值的类型
     */
    public static <T> void distinctByCondition(List<T> list, Function<T,Object> condition){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        Set<Object> set = new HashSet<>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()){
            T next = iterator.next();
            Object value = condition.apply(next);
            if (set.contains(value)){
                iterator.remove();
                continue;
            }
            set.add(value);
        }
    }
}
