package cn.com.duiba.kjy.livecenter.api.enums.push;

import lombok.Getter;

/**
 * 直播推送任务类型枚举
 * @author 吴文哲
 * @date 2020-08-20 16:59
 **/
@Getter
public enum LivePushTaskTypeEnum {

    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME(1,"在直播配置的通知时间通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_BEFORE_BEGIN(2,"在直播开始前5分钟通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVING(3,"在直播开始中每20分钟通知一次代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVED(4,"在直播结束将统计数据发给代理人(客服)"),
    LIVE_USER_APPOINTMENT(5, "直播开播用户订阅消息"),
    LIVE_USER_APPOINTMENT_LOTTERY(17, "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED(18, "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE_SUB(19, "直播开播用户订阅关注消息-推送直播预约关注公司开播提醒"),
    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START(20, "开播前,非直播当天代理人邀请/预约数据统计推送"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START(21, "开播前,代理人排行推送"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START(22, "开播前,代理人邀请用户,每10分钟聚合推送"),

    ;
    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;


    LivePushTaskTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static LivePushTaskTypeEnum getByType(Integer type) {
        for (LivePushTaskTypeEnum enumVal : LivePushTaskTypeEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }




}
