package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 直播间配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
@Getter
public enum LiveExtEnum {

    INVITE_COUNT(1, "代理人指定中奖参与条件,邀请个数"),
    
    ;

    /**
     * 键  长度限制64
     */
    private Integer key;
    /**
     * 描述  长度限制1024
     */
    private String desc;


    LiveExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }


    private static final Map<Integer, LiveExtEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveExtEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key){
        if (StringUtils.isBlank(key)){
            return false;
        }
        for (LiveExtEnum enumVal : LiveExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

}
